%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Example 6.2 
% file AICmin.m
% coded by Dong Li
%
% INPUT: 
% data = time series
% m (here m=8, can be time consuming)
%
% OUTPUT:
% A = [(p1,p2,p3),(r1,r2),d,RSS,(sigma1,sigma2,sigma3),AIC] 
%     an [(m+1)^{3}*11] matrix  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
y = data;
m = 8;  % maximum AR order
A = zeros((m+1)^3,11);
for i=0:m
   for j=0:m
       for k=0:m
          p = [i,j,k];
          est = Estimation(y,p);
          A(i*(m+1)^2+j*(m+1)+(k+1),:) = [p,est(sum(p+1)+1:sum(p+1)+8)];
       end;
   end;
end;

